#!/bin/sh

############################### RunDecrypt.sh ##################################
# You can use this shell to run the application                                #
################################################################################

######################### START: User Defined Section ##########################

# -------------------------------- DEBUG_MODE ----------------------------------
# | Enable/Disable debug mode                                                  |
# | e.g. DEBUG_MODE="--debug"                                                  |
# |  or  DEBUG_MODE=""                                                         |
# ------------------------------------------------------------------------------
DEBUG_MODE=""

########################## END: User Defined Section ###########################


################################################################################
#          R E T R I E V E     A P P _ H O M E     P A T H                     #
################################################################################

EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`

# ------------------------------- SETTING_HOME ---------------------------------
# | Directory to your setting home.                                            |
# ------------------------------------------------------------------------------
SETTING_HOME=""

################################################################################
#          R E T R I E V E     J A V A _ H O M E     P A T H                   #
################################################################################

if [ "Darwin" = `uname` ]; then
    JAVA_HOME="/System/Library/Frameworks/JavaVM.framework/Home"
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "'$APP_HOME/jvm' does not exist!"
    if [ ! -n "$JAVA_HOME" ]; then
        echo "Please set JAVA_HOME!"
        exit 0
    else
        ln -sf "$JAVA_HOME" "$APP_HOME/jvm"
        echo "Created JAVA_HOME symbolic link at '$APP_HOME/jvm'"
    fi
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "Please create symbolic link for '$JAVA_HOME' to '$APP_HOME/jvm'"
    exit 0
fi

JAVA_HOME="$APP_HOME/jvm"
JAVA_EXE="$JAVA_HOME/bin/java"
LD_LIBRARY_PATH="$APP_HOME/bin:$LD_LIBRARY_PATH"
SHLIB_PATH="$LD_LIBRARY_PATH"
export LD_LIBRARY_PATH SHLIB_PATH

# Change to APP_BIN for JAVA execution
cd "${APP_BIN}"

# Reference path will be used to avoid empty space in the parent directory
LIB_HOME=.
JAVA_OPTS="-Xrs -Xms128m -Xmx2048m -XX:MaxDirectMemorySize=512m -client -Dsun.nio.PageAlignDirectMemory=true"
JNI_PATH="-Djava.library.path=$LIB_HOME:$LIB_HOME/MacX84"
CLASSPATH="$LIB_HOME:$LIB_HOME/cb.jar"
MAIN_CLASS=Gui

# Execute Java VM Runtime for BackupManager
echo "Startup Mindtime Pro Backup ... "
"${JAVA_EXE}" $JAVA_OPTS $JNI_PATH -cp $CLASSPATH $MAIN_CLASS "--decrypt" "${DEBUG_MODE}" "${APP_HOME}" "${SETTING_HOME}" &

################################################################################
#                   R E S E T          A N D          E X I T                  #
################################################################################

cd "${EXE_DIR}"
exit 0
