#!/bin/sh
APP_JVM_HOME="../jvm"
AUA_JVM_HOME="./jvm"
JVM_HOME="$APP_JVM_HOME"

if [ "$4" = "MIGRATE" ]; then
    JVM_HOME="$AUA_JVM_HOME"
else
    # add to support define JVM home on java
    if [ ! -z "$4" ]; then
        JVM_HOME="$4"
    fi
fi

if [ -f "$JVM_HOME/bin/javau" ]; then 
    echo "javau exists. Continue update." 
else 
    # copy java as javau to distinguish update process and other processes
    cp "$JVM_HOME/bin/java" "$JVM_HOME/bin/javau" 
    echo "javau added, continue update."
fi

JAVA_EXE="$JVM_HOME/bin/javau"

LIB_HOME="./lib"
JAVA_OPTS="-Xrs -Xmx128m"
JNI_PATH="-Djava.library.path=$LIB_HOME:$LIB_HOME/MacX84"
# AuaI need jdom.jar because Xml classes likes ConfigXML use jdom to parse xml
CLASSPATH="$LIB_HOME:$LIB_HOME/aopalliance-repackaged-2.6.1.jar:$LIB_HOME/aua.jar:$LIB_HOME/bcmail-jdk15to18-164.jar:$LIB_HOME/bcpkix-jdk15to18-164.jar:$LIB_HOME/bcprov-jdk15to18-164.jar:$LIB_HOME/commons-codec-1.11.jar:$LIB_HOME/commons-logging-1.2.1.jar:$LIB_HOME/hk2-api-2.6.1.jar:$LIB_HOME/hk2-locator-2.6.1.jar:$LIB_HOME/hk2-utils-2.6.1.jar:$LIB_HOME/httpclient-4.5.12.jar:$LIB_HOME/httpcore-4.4.13.jar:$LIB_HOME/jackson-annotations-2.12.4.jar:$LIB_HOME/jackson-core-2.12.4.jar:$LIB_HOME/jackson-databind-2.12.4.jar:$LIB_HOME/jackson-module-jaxb-annotations-2.12.4.jar:$LIB_HOME/jakarta.activation-api-1.2.2.jar:$LIB_HOME/jakarta.annotation-api-1.3.5.jar:$LIB_HOME/jakarta.inject-2.6.1.jar:$LIB_HOME/jakarta.validation-api-2.0.2.jar:$LIB_HOME/jakarta.ws.rs-api-2.1.6.jar:$LIB_HOME/jakarta.xml.bind-api-2.3.3.jar:$LIB_HOME/javassist-3.25.0-GA.jar:$LIB_HOME/jdom-1.1.3.jar:$LIB_HOME/jersey-client-2.34.jar:$LIB_HOME/jersey-common-2.34.jar:$LIB_HOME/jersey-container-servlet-core-2.34.jar:$LIB_HOME/jersey-entity-filtering-2.34.jar:$LIB_HOME/jersey-hk2-2.34.jar:$LIB_HOME/jersey-media-json-jackson-2.34.jar:$LIB_HOME/jersey-media-multipart-2.34.jar:$LIB_HOME/jersey-server-2.34.jar:$LIB_HOME/mimepull-1.9.13.jar:$LIB_HOME/org.json-20220924.jar:$LIB_HOME/osgi-resource-locator-1.0.3.jar:$LIB_HOME/snappy-java-1.1.7.3.jar:$LIB_HOME/sqlite-jdbc-3.39.3.0.1.jar"
MAIN_CLASS=AuaI
"$JAVA_EXE" "$JAVA_OPTS" "$JNI_PATH" -cp "$CLASSPATH" "$MAIN_CLASS" "$1" "$2" "$3" > ./Update.txt
if [ "$?" != "0" ]; then
    exit
fi
if [ "$3" = "UI" ]; then
    open '/Applications/MindtimeProBackup.app' &
fi
exit
